/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.fabric;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.fabric.AccessoriesFabric;
import io.wispforest.accessories.fabric.DataLoaderImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.ItemStackAccessor;
import io.wispforest.accessories.utils.ManagedEndecDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3505;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class AccessoriesInternalsImpl {
    public static final ThreadLocal<Map<class_5321<?>, Map<class_2960, Collection<class_6880<?>>>>> LOADED_TAGS = new ThreadLocal();

    public static AccessoriesHolder getHolder(class_1309 livingEntity) {
        return (AccessoriesHolder)livingEntity.getAttachedOrCreate(AccessoriesFabric.HOLDER_ATTACHMENT_TYPE);
    }

    public static void modifyHolder(class_1309 livingEntity, UnaryOperator<AccessoriesHolderImpl> modifier) {
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)AccessoriesInternalsImpl.getHolder(livingEntity);
        holder = (AccessoriesHolderImpl)modifier.apply(holder);
        livingEntity.setAttached(AccessoriesFabric.HOLDER_ATTACHMENT_TYPE, (Object)holder);
    }

    public static void setTags(List<class_3505.class_6863<?>> tags) {
        IdentityHashMap<class_5321, Map> tagMap = new IdentityHashMap<class_5321, Map>();
        for (class_3505.class_6863<?> registryTags : tags) {
            tagMap.put(registryTags.comp_328(), registryTags.comp_329());
        }
        LOADED_TAGS.set(tagMap);
    }

    public static <T> Optional<Collection<class_6880<T>>> getHolder(class_6862<T> tagKey) {
        Map<class_2960, Collection<class_6880<?>>> tags = LOADED_TAGS.get().get(tagKey.comp_326());
        if (tags == null) {
            return Optional.empty();
        }
        Collection<class_6880<?>> holders = tags.get(tagKey.comp_327());
        if (holders == null) {
            return Optional.empty();
        }
        Set converted = holders.stream().map(holder -> holder).collect(Collectors.toUnmodifiableSet());
        return Optional.of(converted);
    }

    public static void giveItemToPlayer(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            PlayerInventoryStorage.of((class_1657)player).offerOrDrop(ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
            transaction.commit();
        }
    }

    public static boolean isValidOnConditions(JsonObject object, String dataType, class_2960 key, @Nullable class_7225.class_7874 registryLookup) {
        return ResourceConditionsImpl.applyResourceConditions((JsonObject)object, (String)dataType, (class_2960)key, (class_7225.class_7874)registryLookup);
    }

    public static <T extends class_1703, D> class_3917<T> registerMenuType(class_2960 location, Endec<D> endec, TriFunction<Integer, class_1661, D, T> func) {
        return (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)location, (Object)new ExtendedScreenHandlerType((arg_0, arg_1, arg_2) -> func.apply(arg_0, arg_1, arg_2), CodecUtils.toPacketCodec(endec)));
    }

    public static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I registerCommandArgumentType(class_2960 location, Class<A> clazz, I info) {
        ArgumentTypeRegistry.registerArgumentType((class_2960)location, clazz, info);
        return info;
    }

    public static void openAccessoriesMenu(class_1657 player, final AccessoriesMenuVariant variant, final @Nullable class_1309 targetEntity, final @Nullable class_1799 carriedStack) {
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory<AccessoriesMenuData>(){

            public AccessoriesMenuData getScreenOpeningData(class_3222 player) {
                return AccessoriesMenuData.of(targetEntity);
            }

            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            public boolean shouldCloseCurrentScreen() {
                return false;
            }

            @Nullable
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                return AccessoriesMenuVariant.openMenu(i, inventory, variant, targetEntity, carriedStack);
            }
        });
    }

    public static void addAttributeTooltips(@Nullable class_1657 player, class_1799 stack, Multimap<class_6880<class_1320>, class_1322> multimap, Consumer<class_2561> tooltipAddCallback, class_1792.class_9635 context, class_1836 flag) {
        for (Map.Entry entry : multimap.entries()) {
            ((ItemStackAccessor)class_1799.field_8037).accessories$addModifierTooltip(tooltipAddCallback, player, (class_6880<class_1320>)((class_6880)entry.getKey()), (class_1322)entry.getValue());
        }
    }

    public static void registerLoader(ManagedEndecDataLoader<?> loader, Consumer<class_7225.class_7874> registrySetCall) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(loader.getLoaderId(), provider -> {
            registrySetCall.accept((class_7225.class_7874)provider);
            return new DataLoaderImpl.IdentifiableResourceReloadListenerImpl(loader.getLoaderId(), (class_3302)loader, new class_2960[0]);
        });
    }
}

